﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class RegistrantRetirementImporter : MilitaryInfoServiceClient
    {
       // eMISMilitaryInformationSerivcePortTypesClient _client;
        #region constructors
        public RegistrantRetirementImporter()
        {          
            _client = new eMISMilitaryInformationSerivcePortTypesClient();
            InputHeaderInfo = new InputHeaderInfo();
        }
        #endregion

        public List<Retirement> GetRetirementData(string edipi)
        {
            eMISretirementResponseType response = GetRetirementResponse(edipi);
            if (response.retirement != null)
            {
                return response.retirement.ToList();
            }
            return new List<Retirement>();
        }
        public eMISretirementResponseType GetRetirementResponse(inputEdiPiOrIcn edipi, InputHeaderInfo headerInfo)
        {
            eMISretirementResponseType retirementResponse = null;
            try
            {
                retirementResponse = _client.getRetirement(ref headerInfo, edipi);
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception: RegistrantRetirementImporter.GetRetirementResponse: " + ex.Message + "\n" + ex.StackTrace);
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return retirementResponse;
        }

        public eMISretirementResponseType GetRetirementResponse(string edipi)
        {
            var inputEdipiIcn = InputEdipiOrIcnCreator.Create(edipi);
            return GetRetirementResponse(inputEdipiIcn, InputHeaderInfo);
        }
    }
}
